/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.mapgen;

import java.util.Random;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.world.classic.ChunkGenTFC;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;

public class MapGenRavineTFC
extends MapGenBase {
    private final float[] multipliers = new float[256];
    private final int height;
    private final int variability;
    private final int ravineRarity;

    public MapGenRavineTFC(int rarity, int h, int v) {
        this.height = h;
        this.variability = v;
        this.ravineRarity = rarity;
    }

    protected void func_180701_a(World worldIn, int chunkX, int chunkZ, int originalX, int originalZ, ChunkPrimer primer) {
        if (this.ravineRarity > 0 && this.field_75038_b.nextInt(this.ravineRarity) == 0) {
            double startX = chunkX * 16 + this.field_75038_b.nextInt(16);
            double startY = this.field_75038_b.nextInt(this.variability) + this.height;
            double startZ = chunkZ * 16 + this.field_75038_b.nextInt(16);
            float angleY = this.field_75038_b.nextFloat() * (float)Math.PI * 2.0f;
            float angleZ = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
            float angleX = (this.field_75038_b.nextFloat() * 2.0f + this.field_75038_b.nextFloat()) * 2.0f;
            double scaleY = 1.2 + (double)this.field_75038_b.nextFloat() + (double)this.field_75038_b.nextFloat();
            this.generateRavine(this.field_75038_b.nextLong(), originalX, originalZ, primer, startX, startY, startZ, angleX, angleY, angleZ, scaleY);
        }
    }

    private void generateRavine(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double xCoord, double yCoord, double zCoord, float angleX, float angleY, float angleZ, double yScale) {
        Random rng = new Random(seed);
        double chunkMidX = chunkX * 16 + 8;
        double chunkMidZ = chunkZ * 16 + 8;
        float runningYMultiplier = 0.0f;
        float runningZMultiplier = 0.0f;
        int rounds = this.field_75040_a * 16 - 16 - rng.nextInt((this.field_75040_a * 16 - 16) / 4);
        float f = 1.0f + rng.nextFloat() * rng.nextFloat() * 1.0f;
        this.multipliers[0] = f * f;
        for (int i = 1; i < 256; ++i) {
            if (rng.nextInt(3) == 0) {
                f = 1.0f + rng.nextFloat() * rng.nextFloat() * 1.0f;
            }
            this.multipliers[i] = f * f;
        }
        block1: for (int round = 0; round < rounds; ++round) {
            int x;
            double min = (1.5 + (double)(MathHelper.func_76126_a((float)((float)round * (float)Math.PI / (float)rounds)) * angleX * 1.0f)) * (double)rng.nextFloat() * 0.25 + 0.75;
            double max = min * yScale * (double)rng.nextFloat() * 0.25 + 0.75;
            float cosZ = MathHelper.func_76134_b((float)angleZ);
            float sinZ = MathHelper.func_76126_a((float)angleZ);
            xCoord += (double)(MathHelper.func_76134_b((float)angleY) * cosZ);
            yCoord += (double)sinZ;
            zCoord += (double)(MathHelper.func_76126_a((float)angleY) * cosZ);
            angleZ *= 0.7f;
            angleY += runningYMultiplier * 0.05f;
            angleZ += runningZMultiplier * 0.05f;
            runningZMultiplier *= 0.8f;
            runningYMultiplier *= 0.5f;
            runningZMultiplier += (rng.nextFloat() - rng.nextFloat()) * rng.nextFloat() * 2.0f;
            runningYMultiplier += (rng.nextFloat() - rng.nextFloat()) * rng.nextFloat() * 4.0f;
            if (rng.nextInt(4) == 0) continue;
            double xOffset = xCoord - chunkMidX;
            double zOffset = zCoord - chunkMidZ;
            double roundsLeft = rounds - round;
            double radius = angleX + 2.0f + 16.0f;
            if (xOffset * xOffset + zOffset * zOffset - roundsLeft * roundsLeft > radius * radius) {
                return;
            }
            if (!(xCoord >= chunkMidX - 16.0 - min * 2.0 && zCoord >= chunkMidZ - 16.0 - min * 2.0 && xCoord <= chunkMidX + 16.0 + min * 2.0 && zCoord <= chunkMidZ + 16.0 + min * 2.0)) continue;
            int xMin = MathHelper.func_76128_c((double)(xCoord - min)) - chunkX * 16 - 1;
            int xMax = MathHelper.func_76128_c((double)(xCoord + min)) - chunkX * 16 + 1;
            int yMin = MathHelper.func_76128_c((double)(yCoord - max)) - 1;
            int yMax = MathHelper.func_76128_c((double)(yCoord + max)) + 1;
            int zMin = MathHelper.func_76128_c((double)(zCoord - min)) - chunkZ * 16 - 1;
            int zMax = MathHelper.func_76128_c((double)(zCoord + min)) - chunkZ * 16 + 1;
            if (xMin < 0) {
                xMin = 0;
            }
            if (xMax > 16) {
                xMax = 16;
            }
            if (yMin < 1) {
                yMin = 1;
            }
            if (yMax > 250) {
                yMax = 250;
            }
            if (zMin < 0) {
                zMin = 0;
            }
            if (zMax > 16) {
                zMax = 16;
            }
            for (x = Math.max(xMin - 1, 0); x < Math.min(xMax + 1, 16); ++x) {
                for (int z = Math.max(zMin - 1, 0); z < Math.min(zMax + 1, 16); ++z) {
                    for (int y = Math.min(yMax + 1, 250); y >= Math.max(yMin - 2, 1); --y) {
                        if (BlocksTFC.isWater(primer.func_177856_a(x, y, z))) continue block1;
                    }
                }
            }
            for (x = xMin; x < xMax; ++x) {
                double xNormalized = ((double)(x + chunkX * 16) + 0.5 - xCoord) / min;
                for (int z = zMin; z < zMax; ++z) {
                    double zNormalized = ((double)(z + chunkZ * 16) + 0.5 - zCoord) / min;
                    if (xNormalized * xNormalized + zNormalized * zNormalized >= 1.0) continue;
                    for (int y = yMax - 1; y >= yMin; --y) {
                        double yNormalized = ((double)y + 0.5 - yCoord) / max;
                        if (!((xNormalized * xNormalized + zNormalized * zNormalized) * (double)this.multipliers[y] + yNormalized * yNormalized / 6.0 < 1.0) || !BlocksTFC.isGround(primer.func_177856_a(x, y, z))) continue;
                        int upCount = 1;
                        while (BlocksTFC.isSoilOrGravel(primer.func_177856_a(x, y + upCount, z))) {
                            primer.func_177855_a(x, y + upCount, z, ChunkGenTFC.AIR);
                            ++upCount;
                        }
                        primer.func_177855_a(x, y, z, y < 20 ? ChunkGenTFC.LAVA : ChunkGenTFC.AIR);
                    }
                }
            }
        }
    }
}

